 
  float calculate1DOverlap(float p0, float p1, float d0, float d1) 
  {
    float dl = p0 + d0 - p1;
    int score = 0;
    float dr = p1 + d1 - p0;  
    return (dr < 0 || dl < 0) ? 0 : (dr >= dl) ? -dl : dr;
  }
  
  void resolvePlayerPlatformCollision(Platform platform, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, platform.x, aPlayer.w, platform.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, platform.y, aPlayer.h, platform.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        player.jumping = false;
        aPlayer.y += yOverlap;
        player.valsnelheid++;
        player.jumpup -= 1;
      } 
      else 
      {        
        player.jumping = false;
        aPlayer.x += xOverlap;
        player.valsnelheid++;
      }
    }
    if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) 
    {
      player.valsnelheid = 0;
    }
    else 
    {
      player.valsnelheid = 10;
    }
  }
  void resolvePlayerNutCollision(Nut nut, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, nut.x, aPlayer.w, nut.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, nut.y, aPlayer.h, nut.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) {
      if (abs(xOverlap) > abs(yOverlap)) {
        // Bij collision verplaatst het juiste nootje naar een positie buiten het speelveld
        nut.x = 99999;
        nut.y = 99999; 
        nutsLeft--;
        sampleBank.trigger("playerNutCollision.wav");
      } else {        
        // Bij collision veplaatst het juiste nootje naar een positie buiten het speelveld
        nut.x = 99999;
        nut.y = 99999;
        nutsLeft--;
        sampleBank.trigger("playerNutCollision.wav");
      }
    }
    if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) {
      // Doe niks als er geen collision is
    }
  }
  void resolvePlayerEnemyCollision(Enemy enemy, Player aPlayer) 
  {
    float xOverlap = calculate1DOverlap(aPlayer.x, enemy.x, aPlayer.w, enemy.w);
    float yOverlap = calculate1DOverlap(aPlayer.y, enemy.y, aPlayer.h, enemy.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        if (player.x != player.startX) 
        {
        }
        sampleBank.trigger("PlayerJumpingOnHead.wav");
        enemy.x = enemy.x + 100000;
        player.jumpup = -17;
      } 
      else 
      {   
  
        player.x = player.startX;
        player.y = player.startY;
        sampleBank.trigger("Buzzer Sound Effect.wav");
      }
    }
  }
  void resolvePlatformEnemyCollision(Enemy enemy, Platform platform) 
  {
    float xOverlap = calculate1DOverlap(platform.x, enemy.x, platform.w, enemy.w);
    float yOverlap = calculate1DOverlap(platform.y, enemy.y, platform.h, enemy.h);
  
    if (abs(xOverlap) > 0 && abs(yOverlap) > 0) 
    {
      if (abs(xOverlap) > abs(yOverlap)) 
      {
        enemy.vx *= -1;
      } else 
      {        
  
        enemy.vx *= -1;
      }
    }
  }
  void resolvePlayerFinishCollision(Finish finish, Player aPlayer) {
  
    if (nutsLeft == 0) {
      float xOverlap = calculate1DOverlap(aPlayer.x, finish.x, aPlayer.w, finish.w);
      float yOverlap = calculate1DOverlap(aPlayer.y, finish.y, aPlayer.h, finish.h);
  
      if (abs(xOverlap) > 0 && abs(yOverlap) > 0) {
        if (abs(xOverlap) > abs(yOverlap)) {
          if (lvl == 1) {
            //aangeven dat de speler op de finish staat
            onFinish = true;
  
  
  
            //de speler naar lvl 2 sturen als hij op de finish staat en op s drukt
            if (onFinish == true && keysPressed['S']) 
            {
              //speler positie zetten
              sampleBank.trigger("Ding Sound Effect.wav");
              player.x = 20500;
              player.y = -800;
  
  
              //aangeven dat de speler niet meer op de finish staat
              onFinish = false;
  
              //lvl nummer op 2 zetten (voor restart en voor spawns van noten)
              lvl = 2;
  
              //nootjes voor level 2 spawnen
              nuts[0].init(23150, -900);
              nuts[1].init(26850, -450);
              nuts[2].init(24150, -2400);
              nuts[3].init(21250, -2810);
              nuts[4].init(26500, -3750);
              nuts[5].init(24450, -4450);
              nuts[6].init(21000, -4950);
              nuts[7].init(26650, -1550);
              nuts[8].init(25250, -5750);
              nuts[9].init(29200, -5850);
              nutsLeft = nuts.length;
              typeyourname.textbox = 0;
            }
          } 
          else 
          {
            //aangeven dat de speler op de finish staat
            onFinish = true;
          }
        } 
        else 
        {  
          if (lvl == 1) {
            //aangeven dat de speler op de finish staat
            onFinish = true;
  
  
            //de speler naar lvl 2 sturen als hij op de finish staat en op a drukt
            if (onFinish == true && keysPressed['S']) {
              //speler positie zetten
              player.x = 20500;
              player.y = -800;
  
              //aangeven dat de speler niet meer op de finish staat
              onFinish = false;
  
              //lvl nummer op 2 zetten (voor restart en voor spawns van noten)
              lvl = 2;
  
              //nootjes voor level 2 spawnen
              nuts[0].init(23150, -900);
              nuts[1].init(26850, -450);
              nuts[2].init(24150, -2400);
              nuts[3].init(21250, -2810);
              nuts[4].init(26500, -3750);
              nuts[5].init(24450, -4450);
              nuts[6].init(21000, -4950);
              nuts[7].init(26650, -1550);
              nuts[8].init(25250, -5750);
              nuts[9].init(29200, -5850);
              nutsLeft = nuts.length;
              typeyourname.textbox = 0;
            }
          } 
          else 
          {
            //aangeven dat de speler op de finish staat
            onFinish = true;
          }
        }
        if (!(abs(xOverlap) > 0 && abs(yOverlap)>0)) 
        {
          player.valsnelheid = 0;
        } 
        else 
        {
          player.valsnelheid = 10;
        }
      }
    }
  }
